/**
 * Created by lei.wang_1 on 2016/11/10.
 */
appModule.directive("subTaskItem", function () {
    return {
        template: `<div class="subTaskContainer" ng-class="{'completed':!subTask.isEditing}">
                    <form class="editingForm" ng-if="subTask.isEditing">
                        <input placeholder="{{'publish.task.task-requirement'|translate}}" class="inputTitle" type="text" ng-model="subTask.title"/>
                        <div class="subTaskTypeOption">
                            <label class="taskTypeLabel" translate="publish.task.feedback-type"></label>
                            <div class="typeOptions">
                                <input type="radio" id="imageSubTask" ng-model="subTask.type" name="subTaskType" value="image"/>
                                <label for="imageSubTask" translate="publish.task.restriction.image"></label>
                                <input type="radio" id="textSubTask" ng-model="subTask.type" name="subTaskType" value="text"/>
                                <label for="textSubTask" translate="publish.task.restriction.text"></label>
                                <input type="radio" id="audioSubTask" ng-model="subTask.type" name="subTaskType" value="audio"/>
                                <label for="audioSubTask" translate="publish.task.restriction.audio"></label>
                            </div>
                        </div>
                        <div class="commentContainer">
                            <text-limit target="subTask.description" max="COMMENT_MAX_LENGTH"></text-limit>
                            <i class="fa" ng-class="{'fa-camera':subTask.type=='image', 'fa-microphone':subTask.type=='audio'}" ng-hide="subTask.type=='text'"></i>
                            <textarea class="commentInput" placeholder="{{'publish.task.task-comment'|translate}}" ng-model="subTask.description"/>
                        </div>
                        <div class="auditorOption">
                            <label translate="publish.task.set-single-auditor"></label>
                            <div class="auditorsContainer">
                                <div class="selectedAuditor" ng-click="toggleAuditorsList()">
                                   <span ng-bind="subTask.auditor.name" class="auditorName"></span>
                                    <i class="fa fa-caret-down" ng-class="{'fa-caret-down':!option.isShowAuditors,'fa-caret-up':option.isShowAuditors}"></i>
                                </div>
                                <ul class="auditors" ng-show="option.isShowAuditors">
                                    <li ng-repeat="auditor in auditors" ng-bind="auditor.name" ng-click="selectedAuditor(auditor)"></li>
                                </ul>
                            </div>
                        </div>
                        <div class="saveInfo">
                            <a class="advanceOptions" ng-click="toggleAdvanceOptions()" ng-show="subTask.type == 'image'">
                                <span translate="publish.task.advanceInfo"></span>
                                <i class="fa" ng-class="{'fa-angle-double-down' : !option.hasAdvanceOptions,'fa-angle-double-up' : option.hasAdvanceOptions}"></i>
                            </a>
                            <div class="btns" ng-show="!option.hasAdvanceOptions">
                                <button class="darkBtn" translate="common.save" ng-click="onSave()" ng-class="{'disabled': !canSaveSubTask()}"></button>
                                <button class="lightBtn"  translate="common.cancel" ng-click="onCancel()"></button>
                            </div>
                        </div>
                        <div class="advanceContainer" ng-show="option.hasAdvanceOptions">
                            <div ng-switch="subTask.type">
                                <!--<div ng-switch-when="text">
                                    <label translate="publish.task.max-text-length"></label>
                                    <input type="number" ng-model="subTask.restriction.max_size" min="0"/>
                                </div>-->
                                <div ng-switch-when="image" class="imageWrapper">
                                    <div>
                                        <notice-checkbox target="option.isRestrictImageNumber" target-text="{{'publish.task.image-number-limit'|translate}}"></notice-checkbox>
                                        <input type="number" ng-model="subTask.restriction.image_num" min="0" value="1" ng-disabled="!option.isRestrictImageNumber"/>
                                    </div>
                                    <div>
                                        <notice-checkbox target="subTask.restriction.require_description" int-type="true" target-text="{{'publish.task.image-require-description'|translate}}"></notice-checkbox>
                                    </div>
                                </div>
                            </div>
                            <div class="advanceOption">
                                <div class="btns">
                                    <button class="darkBtn" translate="common.save" ng-click="onSave()" ng-class="{'disabled': !canSaveSubTask()}"></button>
                                    <button class="lightBtn"  translate="common.cancel" ng-click="onCancel()"></button>
                                </div>
                            </div>                            
                        </div>
                    </form>
                    <div class="infoDiv" ng-if="!subTask.isEditing">
                       <span ng-bind="index + 1" class="index"></span>
                        <div class="title text-ellipsis" ng-bind="subTask.title"></div>
                        <div ng-switch="subTask.type" class="info">
                            <div ng-switch-when="text" class="text">
                                 <span class="description" ng-bind="subTask.description"></span>
                            </div>
                             <div ng-switch-when="image" class="image">
                                <i class="fa fa-camera"></i>
                                <div class="description">
                                    <span ng-bind="subTask.description"></span>
                                    <span ng-show="subTask.restriction.image_num > 0">
                                        <span>(</span>
                                        <span ng-bind="subTask.restriction.image_num"></span>
                                        <span>)</span>
                                    </span>                                     
                                </div>                                 
                            </div>
                            <div ng-switch-when="audio" class="audio">
                                 <i class="fa fa-microphone"></i>
                                 <div ng-bind="subTask.description" class="description"></div>
                            </div>
                        </div>
                        <div class="btns">
                            <a class="move"><i class="icon-move"></i></a>
                            <a class="edit" ng-click="onEdit()"><i class="icon-edit"></i></a>
                            <a class="delete" ng-click="onDelete({index:index})"><i class="icon-delete"></i></a>
                        </div>
                        <div ng-hide="subTask.audit_user_id" class="chooseAuditorTooltip">
                            <span translate="publish.choose-auditor-tooltip"></span>
                        </div>
                    </div>
                </div>`,
        scope: {
            subTask: "=",
            auditors: "=",
            onDelete: "&",
            index: "="
        },
        restrict: "E",
        replace: true,
        link: function ($scope) {
            $scope.DEFAULT_TEXT_MAX_LENGTH = 500;
            $scope.COMMENT_MAX_LENGTH = 50;
            $scope.option={
                isRestrictImageNumber:true,
                hasAdvanceOptions:false,
                isShowAuditors:false

            };
            $scope.toggleAdvanceOptions = function () {
                $scope.option.hasAdvanceOptions = !$scope.option.hasAdvanceOptions;
            };

            $scope.toggleAuditorsList = function (value) {
                if(value != undefined){
                    $scope.option.isShowAuditors = value;
                    return;
                }
                $scope.option.isShowAuditors = !$scope.option.isShowAuditors;
            };

            $scope.selectedAuditor = function (auditor) {
                $scope.subTask.auditor = auditor;
                $scope.toggleAuditorsList();
            };

            $scope.onSave = function () {
                if ($scope.canSaveSubTask()) {
                    $scope.subTask.isEditing = false;
                    $scope.previousSubTask = null;
                }
            };

            $scope.onEdit = function () {
                $scope.previousSubTask = $.extend({}, $scope.subTask);
                $scope.subTask.isEditing = true;
            };

            $scope.onCancel = function () {
                if ($scope.previousSubTask) {
                    $scope.subTask = $.extend($scope.subTask, $scope.previousSubTask);
                    return;
                }

                $scope.onDelete({index: $scope.index});
            };

            $scope.canSaveSubTask = function () {
                return $scope.subTask.title 
                    && $scope.subTask.type
                    && $scope.subTask.audit_user_id
                    && (!$scope.subTask.description || $scope.subTask.description.length <= $scope.COMMENT_MAX_LENGTH)
                    && ($scope.subTask.type != 'image' || ($scope.subTask.type == 'image' && (!$scope.option.isRestrictImageNumber|| $scope.subTask.restriction.image_num > 0)));
            };

            var stopWatchType = $scope.$watch("subTask.type", function (newV) {
                if (newV == 'image') {
                    if($scope.subTask.restriction.image_num == undefined){
                        $scope.option.isRestrictImageNumber = true;
                        $scope.subTask.restriction.image_num = 1;
                    }else if($scope.subTask.restriction.image_num == 0){
                        $scope.option.isRestrictImageNumber = false;
                    }
                }
            });
            var stopWatchImageNumberRestriction = $scope.$watch("option.isRestrictImageNumber", function (newV) {
                if (!newV) {
                    $scope.subTask.restriction.image_num = 0;
                }
            });

            var stopWatchAuditor = $scope.$watch("subTask.auditor", function (newV) {
                if (newV) {
                    $scope.subTask.audit_user_id = $scope.subTask.auditor.id;
                }
            });

            var offBodyClick = $scope.$on('onBodyClick',function(e,target){
                if($(target).closest('.auditorsContainer').length == 0){
                    $scope.toggleAuditorsList(false);
                }
            });

            $scope.$on("$destroy", function () {
                stopWatchAuditor();
                stopWatchType();
                stopWatchImageNumberRestriction();
                offBodyClick();
            });
        }
    }
});